local this = {}

function this.CreateSprite(initial_tex,initial_x,initial_y,absolute)
	local self = {
		texture=initial_tex,
		isactive=true,
		projectile=nil,
		x=initial_x,
		y=initial_y,
		absx=initial_x+320,
		absy=initial_y+160,
		dataHolder={}
	}

	function self.Create()
		if(self.projectile ~= nil and self.projectile.isactive) then
			self.projectile.Remove()
		end
		self.isactive = false
		self.projectile = CreateProjectile(self.texture, self.x, self.y)
		self.projectile.SetVar("sprite",true)
		self.projectile.SetVar("wrapper",this)
	end

	function self.SetSprite(spritename)
		self.texture = spritename
		self.Create()
	end

	function self.MoveTo(x,y)
		self.x = x
		self.y = y
		self.absx = x + 320
		self.absy = y + 160
		self.projectile.MoveToAbs(self.absx, self.absy)
	end

	function self.MoveToAbs(x,y)
		self.MoveTo(x - 320, y - 160)
	end

	function self.Move(x,y)
		self.MoveTo(self.x + x, self.y + y)
	end

	function self.SetVar(key,value)
		self.dataHolder[key] = value
	end

	function self.GetVar(key)
		return self.dataHolder[key]
	end

	function self.Remove()
		self.isactive = false
		self.projectile.Remove()
	end

	function self.SendToTop()
		self.projectile.SendToTop()
	end

	function self.SendToBottom()
		self.projectile.SendToBottom()
	end

	self.Create()
	if absolute then
		self.MoveToAbs(initial_x, initial_y)
	end

	return self
end

return this